/*
 * Copyright (c) 2019 Amazon.com, Inc. or its affiliates.  All rights
 * reserved.
 * Portions Copyright (C) 2018 Sigmastar Technology Corp
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef INCLUDED_AMAZON_NET_IOCTL_H_
#define INCLUDED_AMAZON_NET_IOCTL_H_

#include <linux/sockios.h>

#define SIOCGETQUEUEDPACKETCOUNT  (SIOCDEVPRIVATE + 0)
#define SIOCGETQUEUEDBYTECOUNT    (SIOCDEVPRIVATE + 1)

/* Structure for Amazon SDIO IOCTL commands
 * (data part must not exceed 16 bytes)
 */
struct if_amazon_sdio_req {
	union {
		/* interface name, e.g. "amazon_sdio0" */
		char ifrn_name[IFNAMSIZ];
	} ifr_ifrn;

	/* Data part */
	union {
		struct {
			unsigned char      channel;
			unsigned int       count;
		} ifru_queued_count;
	} ifr_ifru;
};

#endif // ifdef INCLUDED_AMAZON_NET_IOCTL_H_
